/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.rute_tests;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.block_growths.Operator;
import com.ordana.immersive_weathering.reg.ModRuleTests;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3825;
import net.minecraft.class_3827;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BlockPropertyTest
extends class_3825 {
    public static final Codec<BlockPropertyTest> CODEC = PropPredicate.CODEC.listOf().fieldOf("properties").xmap(BlockPropertyTest::new, t -> t.propPredicates).codec();
    private final List<PropPredicate> propPredicates;

    private BlockPropertyTest(List<PropPredicate> propPredicates) {
        this.propPredicates = propPredicates;
    }

    public boolean method_16768(class_2680 state, class_5819 random) {
        for (PropPredicate p : this.propPredicates) {
            if (p.test(state)) continue;
            return false;
        }
        return true;
    }

    protected class_3827<BlockPropertyTest> method_16766() {
        return ModRuleTests.BLOCK_PROPERTY_TEST.get();
    }

    protected static Codec<Comparable<?>> valueCodec(class_2769<?> property) {
        return Codec.STRING.flatXmap(string -> property.method_11900(string).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown Property value" + string + " in " + property))), value -> DataResult.success((Object)value.toString()));
    }

    protected static Codec<class_2769<? extends Comparable<?>>> propertyCodec(class_2680 state) {
        return Codec.STRING.flatXmap(string -> {
            for (class_2769 p : state.method_28501()) {
                if (!p.method_11899().equals(string)) continue;
                return DataResult.success((Object)p);
            }
            return DataResult.error((String)("Unknown Property " + string + " in " + state));
        }, property1 -> DataResult.success((Object)property1.method_11899()));
    }

    private static final class PropPredicate
    implements Predicate<class_2680> {
        public static Codec<PropPredicate> CODEC = class_2378.field_11146.method_39673().partialDispatch("from_block", b -> DataResult.success((Object)b.getFromBlock()), block -> {
            class_2680 state = block.method_9564();
            if (state.method_11656().isEmpty()) {
                return DataResult.error((String)"Target Block has no properties");
            }
            Codec c = BlockPropertyTest.propertyCodec(state).partialDispatch("property", b -> DataResult.success(b.getProperty()), property -> {
                Codec c1 = RecordCodecBuilder.create(i -> i.group((App)BlockPropertyTest.valueCodec(property).optionalFieldOf("value").forGetter(PropPredicate::getTargetValue), (App)Operator.CODEC.optionalFieldOf("operator", (Object)Operator.EQUAL).forGetter(PropPredicate::getOperator)).apply((Applicative)i, (v, o) -> new PropPredicate((class_2248)block, (class_2769<?>)property, (Optional<Comparable<?>>)v, (Operator)((Object)((Object)((Object)((Object)o)))))));
                return DataResult.success((Object)c1);
            });
            return DataResult.success((Object)c);
        });
        private final class_2248 fromBlock;
        private final class_2769<?> property;
        private final Operator operator;
        @Nullable
        private final Comparable<?> targetValue;
        private final Integer intValue;

        public PropPredicate(class_2248 fromBlock, class_2769<?> property, Optional<Comparable<?>> value, Operator operator) {
            Integer i;
            Comparable<?> comparable;
            this.property = property;
            this.targetValue = value.orElse(null);
            this.fromBlock = fromBlock;
            this.operator = operator;
            this.intValue = property instanceof class_2758 && operator != null && (comparable = this.targetValue) instanceof Integer ? (i = (Integer)comparable) : null;
        }

        public class_2248 getFromBlock() {
            return this.fromBlock;
        }

        public Optional<Comparable<?>> getTargetValue() {
            return Optional.ofNullable(this.targetValue);
        }

        public class_2769<?> getProperty() {
            return this.property;
        }

        public Operator getOperator() {
            return this.operator;
        }

        @Override
        public boolean test(class_2680 state) {
            Optional val = state.method_28500(this.property);
            if (val.isPresent()) {
                if (this.intValue != null) {
                    return this.operator.apply((Integer)val.get(), this.intValue);
                }
                return this.targetValue == null || val.get() == this.targetValue;
            }
            return false;
        }
    }
}

